-- phpMyAdmin SQL Dump
-- version 5.1.3
-- https://www.phpmyadmin.net/
--
-- Hôte : localhost
-- Généré le : lun. 13 mars 2023 à 16:53
-- Version du serveur : 10.5.12-MariaDB-0+deb11u1
-- Version de PHP : 7.4.30

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
START TRANSACTION;
SET time_zone = "+00:00";

--
-- Base de données : `zdl3-zle_targw_1`
--

DELIMITER $$
--
-- Procédures
--
CREATE DEFINER=`zle_targw`@`%` PROCEDURE `linkConcoursCategories` (IN `idConcours` INT, IN `nomCategorie` TEXT)   BEGIN
    -- Boucle pour chaque catégorie
    FOR categorie IN (SELECT * FROM t_categorie_cat) DO
        SET @id_categorie = categorie.cat_idCategorie;
        SET @nom_categorie_courant = categorie.cat_nomCategorie;
        -- Vérifier si le nom de la catégorie contient la chaîne indiquée
        IF @nom_categorie_courant LIKE nomCategorie THEN
            -- Insérer une entrée dans la table "t_possede_poss" pour la catégorie courante
            INSERT INTO t_possede_poss(conc_idConcours, cat_idCategorie)
            VALUES (idConcours, @id_categorie);
        END IF;
    END FOR;
END$$

CREATE DEFINER=`zle_targw`@`%` PROCEDURE `majDates` ()   BEGIN
UPDATE `t_concours_conc` SET `conc_date_debut`=DATE_SUB(CURRENT_DATE(), INTERVAL 5 DAY) WHERE `conc_idConcours` = 1;
UPDATE `t_concours_conc` SET `conc_date_debut`=DATE_SUB(CURRENT_DATE(), INTERVAL 4 DAY) WHERE `conc_idConcours` = 2;
UPDATE `t_concours_conc` SET `conc_date_debut`=DATE_SUB(CURRENT_DATE(), INTERVAL 3 DAY) WHERE `conc_idConcours` = 3;
UPDATE `t_concours_conc` SET `conc_date_debut`=DATE_SUB(CURRENT_DATE(), INTERVAL 2 DAY) WHERE `conc_idConcours` = 4;
UPDATE `t_concours_conc` SET `conc_date_debut`=DATE_SUB(CURRENT_DATE(), INTERVAL 1 DAY) WHERE `conc_idConcours` = 5;
UPDATE `t_concours_conc` SET `conc_date_debut`=DATE_SUB(CURRENT_DATE(), INTERVAL 0 DAY) WHERE `conc_idConcours` = 6;
UPDATE `t_concours_conc` SET `conc_date_debut`=DATE_ADD(CURRENT_DATE(), INTERVAL 1 DAY) WHERE `conc_idConcours` = 7;

UPDATE `t_concours_conc` 
SET `conc_date_debut_selection`=DATE_ADD(`conc_date_debut`, INTERVAL 2 DAY),
    `conc_date_debut_finale`=DATE_ADD(`conc_date_debut`, INTERVAL 3 DAY),
    `conc_date_fin`=DATE_ADD(`conc_date_debut`, INTERVAL 4 DAY);
END$$

--
-- Fonctions
--
CREATE DEFINER=`zle_targw`@`%` FUNCTION `donnerCategoriesConcours` (`concId` INT) RETURNS TEXT CHARSET utf8mb4  BEGIN
    RETURN (SELECT GROUP_CONCAT(cat_nomCategorie SEPARATOR ', ') 
    FROM (t_concours_conc C JOIN t_possede_poss P USING(conc_idConcours)) JOIN t_categorie_cat D USING(cat_idCategorie)
    WHERE C.conc_idConcours = concId);
END$$

CREATE DEFINER=`zle_targw`@`%` FUNCTION `donnerJuryConcours` (`concId` INT) RETURNS TEXT CHARSET utf8mb4  BEGIN
    RETURN CONCAT_WS(", ", (SELECT GROUP_CONCAT(CONCAT_WS("", cpt_prenom, " ", cpt_nom, " (", jury_discipline, ")") SEPARATOR ', ') 
    FROM ((t_concours_conc C JOIN t_siege_siege S ON C.conc_idConcours = S.conc_idConcours) JOIN t_compte_jury J ON J.cpt_pseudo = S.cpt_pseudo) JOIN t_compte_cpt A ON J.cpt_pseudo= A.cpt_pseudo
    WHERE C.conc_idConcours = concId));
END$$

CREATE DEFINER=`zle_targw`@`%` FUNCTION `donnerPhaseConcours` (`concId` INT) RETURNS TEXT CHARSET utf8mb4  BEGIN
    SET @conc_date_debut = (SELECT conc_date_debut FROM t_concours_conc WHERE conc_idConcours = concId);
    SET @conc_date_selection = (SELECT conc_date_debut_selection FROM t_concours_conc WHERE conc_idConcours = concId);
    SET @conc_date_finale = (SELECT conc_date_debut_finale FROM t_concours_conc WHERE conc_idConcours = concId);
    SET @conc_date_fin = (SELECT conc_date_fin FROM t_concours_conc WHERE conc_idConcours = concId);
    
    IF CURRENT_DATE() < @conc_date_debut THEN
        RETURN "V";
    ELSEIF CURRENT_DATE() >= @conc_date_debut AND CURRENT_DATE() < @conc_date_selection THEN
        RETURN "I";
    ELSEIF CURRENT_DATE() >= @conc_date_selection AND CURRENT_DATE() < @conc_date_finale THEN
        RETURN "S";
    ELSEIF CURRENT_DATE() >= @conc_date_finale AND CURRENT_DATE() < @conc_date_fin THEN
        RETURN "F";
    ELSEIF CURRENT_DATE() >= @conc_date_fin THEN
        RETURN "T";
    ELSE
        RETURN "E"; -- = Erreur
    END IF;
END$$

CREATE DEFINER=`zle_targw`@`%` FUNCTION `getLastConcours` () RETURNS INT(11)  BEGIN
    SET @lastConc = -1;
    SELECT MAX(conc_idConcours) INTO @lastConc FROM t_concours_conc;
    RETURN @lastConc;
END$$

DELIMITER ;

-- --------------------------------------------------------

--
-- Structure de la table `t_actualite_act`
--

CREATE TABLE `t_actualite_act` (
  `act_idActualite` int(11) NOT NULL,
  `act_titre` varchar(200) NOT NULL,
  `act_message` varchar(500) NOT NULL,
  `cpt_pseudo` varchar(50) NOT NULL,
  `act_etat` char(1) NOT NULL,
  `act_date` date NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

--
-- Déchargement des données de la table `t_actualite_act`
--

INSERT INTO `t_actualite_act` (`act_idActualite`, `act_titre`, `act_message`, `cpt_pseudo`, `act_etat`, `act_date`) VALUES
(1, 'Dates du prochains concours.', 'Le concours d\'escalade aura lieu les 5 et 6 juin prochains. Inscrivez-vous dès maintenant !', 'j.dupont', 'P', '0000-00-00'),
(2, 'Participation d\'un champion', 'Nous avons le plaisir de vous annoncer la participation de plusieurs champions internationaux à notre compétition.', 'f.martin', 'P', '0000-00-00'),
(3, 'Nouvelle réglementation', 'La règlementation de la compétition a été mise à jour. Merci de la consulter avant de vous inscrire.', 'j.dupont', 'P', '0000-00-00'),
(4, 'Ateliers d\'entrainement', 'Des ateliers d\'entraînement seront proposés les 3 et 4 juin pour les participants.', 'f.martin', 'C', '0000-00-00'),
(5, 'Inscription ouverte', 'L\'inscription à la compétition est ouverte jusqu\'au 30 avril.', 'j.dupont', 'C', '0000-00-00'),
(6, 'Les prix remis aux grimpeurs', 'Des prix seront remis aux meilleurs grimpeurs de chaque catégorie.', 'f.martin', 'P', '0000-00-00'),
(7, 'Choix du lieu du prochain concours', 'La compétition se déroulera dans la salle d\'escalade de Grenoble.', 'j.dupont', 'P', '0000-00-00');

-- --------------------------------------------------------

--
-- Structure de la table `t_categorie_cat`
--

CREATE TABLE `t_categorie_cat` (
  `cat_idCategorie` int(11) NOT NULL,
  `cat_nomCategorie` varchar(50) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

--
-- Déchargement des données de la table `t_categorie_cat`
--

INSERT INTO `t_categorie_cat` (`cat_idCategorie`, `cat_nomCategorie`) VALUES
(1, 'U14 difficulté homme'),
(2, 'U14 difficulté femme'),
(3, 'U14 vitesse homme'),
(4, 'U14 vitesse femme'),
(5, 'U14 bloc homme'),
(6, 'U14 bloc femme'),
(7, 'U16 difficulté homme'),
(8, 'U16 difficulté femme'),
(9, 'U16 vitesse homme'),
(10, 'U16 vitesse femme'),
(11, 'U16 bloc homme'),
(12, 'U16 bloc femme'),
(13, 'U18 difficulté homme'),
(14, 'U18 difficulté femme'),
(15, 'U18 vitesse homme'),
(16, 'U18 vitesse femme'),
(17, 'U18 bloc homme'),
(18, 'U18 bloc femme'),
(19, 'U20 difficulté homme'),
(20, 'U20 difficulté femme'),
(21, 'U20 vitesse homme'),
(22, 'U20 vitesse femme'),
(23, 'U20 bloc homme'),
(24, 'U20 bloc femme'),
(25, 'Sénior difficulté homme'),
(26, 'Sénior difficulté femme'),
(27, 'Sénior vitesse homme'),
(28, 'Sénior vitesse femme'),
(29, 'Sénior bloc homme'),
(30, 'Sénior bloc femme'),
(31, 'Vétéran difficulté homme'),
(32, 'Vétéran difficulté femme'),
(33, 'Vétéran vitesse homme'),
(34, 'Vétéran vitesse femme'),
(35, 'Vétéran bloc homme'),
(36, 'Vétéran bloc femme');

-- --------------------------------------------------------

--
-- Structure de la table `t_compte_cpt`
--

CREATE TABLE `t_compte_cpt` (
  `cpt_pseudo` varchar(50) NOT NULL,
  `cpt_mdp` char(64) NOT NULL,
  `cpt_nom` varchar(80) NOT NULL,
  `cpt_prenom` varchar(80) NOT NULL,
  `cpt_etat` char(1) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

--
-- Déchargement des données de la table `t_compte_cpt`
--

INSERT INTO `t_compte_cpt` (`cpt_pseudo`, `cpt_mdp`, `cpt_nom`, `cpt_prenom`, `cpt_etat`) VALUES
('a.david', 'c603e1640817822f6899dedbd4790ad9341521516d9cd763c389592f936f6af7', 'David', 'Anne', 'A'),
('b.garcia', '1675f2f4d5d3fc5b9fd6c3343946cc2ca4b7bd3768f1af36f5c35776c610ed3b', 'Garcia', 'Bruno', 'A'),
('c.leroy', 'd947b5f8eeaea72a77a9ce1b903869d53bdab6950a06cc34681d3bccbdb5ff08', 'Leroy', 'Céline', 'A'),
('d.roux', '0604ad843fedfca23374282a77d9c9c22d1874f14056d2dab2a1cd7533ea67cd', 'Roux', 'Damien', 'A'),
('e.petit', '256a40eaf6a4079b1b9295a690f14ebeb890ed595aab192c27e65726c22f8ab0', 'Petit', 'Emilie', 'A'),
('f.martin', '344bafd63216e4e4ba54b5969e875df0807cf19f75757b61f2373f8ab1f42fa0', 'Martin', 'François', 'A'),
('g.vergne', 'da82303e85b66865ff0c2c6990665ddb5052db199cc708340dc2502a388269fa', 'Vergne', 'Guillaume', 'A'),
('h.bertrand', '825f3ebd10c11cb55d6c2fddf4a101a75789ee35edcd0d74ee07c9184c750701', 'Bertrand', 'Hélène', 'A'),
('i.carpentier', 'f83904fa8a8276192e56e0c08a10967645bdb40390662a8d5efd5c480d8653d9', 'Carpentier', 'Isabelle', 'A'),
('j.dupont', 'b49d1fcd5379cb841d17e4cc03f6eb5674d244c79dfac1689904653c9b4f9508', 'Dupont', 'Jacques', 'A'),
('organisateur', 'ff4c1b6699635c0bfe5d68e3c7eb26d298fb5e18e569ff5ce530b7267647dcff', 'Nizateur', 'Orga', 'A');

-- --------------------------------------------------------

--
-- Structure de la table `t_compte_jury`
--

CREATE TABLE `t_compte_jury` (
  `jury_discipline` varchar(30) NOT NULL,
  `jury_url` varchar(300) NOT NULL,
  `jury_bio` varchar(500) NOT NULL,
  `cpt_pseudo` varchar(50) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

--
-- Déchargement des données de la table `t_compte_jury`
--

INSERT INTO `t_compte_jury` (`jury_discipline`, `jury_url`, `jury_bio`, `cpt_pseudo`) VALUES
('Difficulté', 'http://www.adavid.com', 'Anne David est une grimpeuse expérimentée et un entraîneur certifié.', 'a.david'),
('Vitesse', 'http://www.bgarcia.com', 'Bruno Garcia est un grimpeur passionné et un membre actif de plusieurs clubs.', 'b.garcia'),
('Vitesse', 'http://www.cleroy.com', 'Céline Leroy est une grimpeuse passionnée et un membre actif de plusieurs clubs.', 'c.leroy'),
('Difficulté', 'http://www.droux.com', 'Damien Roux est un grimpeur passionné et un membre actif de plusieurs clubs.', 'd.roux'),
('Bloc', 'http://www.epetit.com', 'Emilie Petit est une grimpeuse compétitive et un membre actif de plusieurs clubs.', 'e.petit'),
('Bloc', 'http://www.gvergne.com', 'Guillaume Vergne est un grimpeur passionné et un membre actif de plusieurs clubs.', 'g.vergne'),
('Bloc', 'http://www.hbertrand.com', 'Hélène Bertrand est une grimpeuse passionnée et un membre actif de plusieurs clubs.', 'h.bertrand'),
('Vitesse', 'http://www.icarpentier.com', 'Isabelle Carpentier est une grimpeuse expérimentée et un membre actif de plusieurs clubs.', 'i.carpentier');

-- --------------------------------------------------------

--
-- Structure de la table `t_compte_org`
--

CREATE TABLE `t_compte_org` (
  `cpt_pseudo` varchar(50) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

--
-- Déchargement des données de la table `t_compte_org`
--

INSERT INTO `t_compte_org` (`cpt_pseudo`) VALUES
('f.martin'),
('j.dupont');

-- --------------------------------------------------------

--
-- Structure de la table `t_concours_conc`
--

CREATE TABLE `t_concours_conc` (
  `conc_idConcours` int(11) NOT NULL,
  `conc_nomConcours` varchar(50) NOT NULL,
  `conc_date_debut` date NOT NULL,
  `conc_date_debut_selection` date NOT NULL,
  `conc_date_debut_finale` date NOT NULL,
  `conc_date_fin` date NOT NULL,
  `conc_description` varchar(200) NOT NULL,
  `cpt_pseudo` varchar(50) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

--
-- Déchargement des données de la table `t_concours_conc`
--

INSERT INTO `t_concours_conc` (`conc_idConcours`, `conc_nomConcours`, `conc_date_debut`, `conc_date_debut_selection`, `conc_date_debut_finale`, `conc_date_fin`, `conc_description`, `cpt_pseudo`) VALUES
(1, 'Grenoble Open', '2023-03-08', '2023-03-10', '2023-03-11', '2023-03-12', 'Compétition internationale d\'escalade organisée à Grenoble', 'j.dupont'),
(2, 'Championnat de France', '2023-03-09', '2023-03-11', '2023-03-12', '2023-03-13', 'Rassemblement des meilleurs grimpeurs français', 'f.martin'),
(3, 'Coupe de l\'Isère', '2023-03-10', '2023-03-12', '2023-03-13', '2023-03-14', 'Compétition régionale ouverte à tous les grimpeurs', 'j.dupont'),
(4, 'Bloc Party', '2023-03-11', '2023-03-13', '2023-03-14', '2023-03-15', 'Compétition de blocs organisée par les étudiants de l\'Université Grenoble Alpes', 'f.martin'),
(5, 'Grenoble Bouldering', '2023-03-12', '2023-03-14', '2023-03-15', '2023-03-16', 'Compétition de blocs en extérieur dans les alentours de Grenoble', 'j.dupont'),
(6, 'Vertical Race', '2023-03-13', '2023-03-15', '2023-03-16', '2023-03-17', 'Compétition de vitesse organisée sur un mur d\'escalade extérieur', 'f.martin'),
(7, 'Grenoble Masters', '2023-03-14', '2023-03-16', '2023-03-17', '2023-03-18', 'Compétition réservée aux grimpeurs adultes', 'j.dupont');

--
-- Déclencheurs `t_concours_conc`
--
DELIMITER $$
CREATE TRIGGER `addActualiteOnNewConcours` AFTER INSERT ON `t_concours_conc` FOR EACH ROW BEGIN
    CALL creerActualite();
END
$$
DELIMITER ;

-- --------------------------------------------------------

--
-- Structure de la table `t_document_doc`
--

CREATE TABLE `t_document_doc` (
  `doc_idDocument` int(11) NOT NULL,
  `doc_chemin` varchar(200) NOT NULL,
  `doc_type` varchar(45) NOT NULL,
  `part_mail` varchar(300) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Structure de la table `t_fil_fil`
--

CREATE TABLE `t_fil_fil` (
  `fil_idFil` int(11) NOT NULL,
  `fil_titre` varchar(50) NOT NULL,
  `fil_description` varchar(200) NOT NULL,
  `conc_idConcours` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

--
-- Déchargement des données de la table `t_fil_fil`
--

INSERT INTO `t_fil_fil` (`fil_idFil`, `fil_titre`, `fil_description`, `conc_idConcours`) VALUES
(1, 'Discussion sur le concours U14 difficulté homme', 'Ce fil de discussion est dédié au concours de difficulté U14 pour les hommes. Les membres du jury peuvent discuter des performances des candidats et partager leur avis.', 1),
(2, 'Discussion sur le concours U14 vitesse homme', 'Ce fil de discussion est dédié au concours de vitesse U14 pour les hommes. Les membres du jury peuvent discuter des performances des candidats et partager leur avis.', 2),
(3, 'Discussion sur le concours U14 bloc homme', 'Ce fil de discussion est dédié au concours de bloc U14 pour les hommes. Les membres du jury peuvent discuter des performances des candidats et partager leur avis.', 3),
(4, 'Discussion sur le concours U14 difficulté femme', 'Ce fil de discussion est dédié au concours de difficulté U14 pour les femmes. Les membres du jury peuvent discuter des performances des candidats et partager leur avis.', 4),
(5, 'Discussion sur le concours U14 vitesse femme', 'Ce fil de discussion est dédié au concours de vitesse U14 pour les femmes. Les membres du jury peuvent discuter des performances des candidats et partager leur avis.', 5),
(6, 'Discussion sur le concours U14 bloc femme', 'Ce fil de discussion est dédié au concours de bloc U14 pour les femmes. Les membres du jury peuvent discuter des performances des candidats et partager leur avis.', 6),
(7, 'Discussion sur le concours U16 difficulté homme', 'Ce fil de discussion est dédié au concours de difficulté U16 pour les hommes. Les membres du jury peuvent discuter des performances des candidats et partager leur avis.', 7);

-- --------------------------------------------------------

--
-- Structure de la table `t_message_msg`
--

CREATE TABLE `t_message_msg` (
  `msg_idMessage` int(11) NOT NULL,
  `msg_texte` varchar(500) NOT NULL,
  `msg_date` date DEFAULT NULL,
  `fil_idFil` int(11) NOT NULL,
  `cpt_pseudo` varchar(50) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

--
-- Déchargement des données de la table `t_message_msg`
--

INSERT INTO `t_message_msg` (`msg_idMessage`, `msg_texte`, `msg_date`, `fil_idFil`, `cpt_pseudo`) VALUES
(1, 'Je suis impressionné par les performance des candidats de la catégorie U14 difficulté', '2022-05-01', 1, 'c.leroy'),
(2, 'Je suis d\'accord, ils ont tous un très bon niveau technique', '2022-05-02', 1, 'a.david'),
(3, 'Il y a un candidat en particulier qui m\'a vraiment marqué, il a un potentiel incroyable', '2022-05-03', 1, 'b.garcia'),
(4, 'Je suis d\'accord avec vous, il est vraiment prometteur', '2022-05-04', 1, 'e.petit'),
(5, 'Je pense qu\'il mérite une mention spéciale', '2022-05-05', 1, 'd.roux'),
(6, 'On devrait l\'encourager à poursuivre dans cette voie', '2022-05-06', 1, 'g.vergne'),
(7, 'Je suis d\'accord, il a vraiment un avenir prometteur dans l\'escalade', '2022-05-07', 1, 'h.bertrand'),
(8, 'Je vais noter cela dans mes commentaires', '2022-05-08', 1, 'i.carpentier'),
(9, 'Bonjour, je voulais discuter des performances des candidats U14 en difficulté', '2022-12-01', 2, 'c.leroy'),
(10, 'Salut, je suis d\'accord avec toi. J\'ai remarqué que certains manquaient de technique', '2022-12-02', 2, 'a.david'),
(11, 'Oui, c\'est vrai. Peut-être qu\'il faudrait les entraîner davantage avant le concours', '2022-12-03', 2, 'b.garcia'),
(12, 'Bonjour, je voulais discuter des performances des candidats U16 en vitesse', '2022-12-04', 3, 'e.petit'),
(13, 'Salut, je suis d\'accord avec toi. J\'ai remarqué que certains manquaient de rapidité', '2022-12-05', 3, 'd.roux'),
(14, 'Oui, c\'est vrai. Peut-être qu\'il faudrait les entraîner davantage avant le concours', '2022-12-06', 3, 'g.vergne'),
(15, 'Bonjour, je suis intéressé par les performances des candidats U14 en difficulté.', '2022-12-01', 4, 'c.leroy'),
(16, 'Je suis d\'accord, il y a beaucoup de potentiel chez cette catégorie.', '2022-12-02', 4, 'a.david'),
(17, 'Je suis également intéressé par les performances des candidats U14 en vitesse.', '2022-12-03', 4, 'b.garcia'),
(18, 'Il y a des progrès à faire pour les candidats U14 en bloc.', '2022-12-04', 4, 'e.petit'),
(19, 'J\'aimerais discuter des résultats des candidates U14 en difficulté.', '2022-12-05', 4, 'd.roux'),
(20, 'Je suis d\'accord, il faut continuer à suivre les performances de cette catégorie.', '2022-12-06', 4, 'g.vergne'),
(21, 'Il y a des talents prometteurs chez les U14, il faut continuer à les encourager.', '2022-12-07', 4, 'h.bertrand'),
(22, 'Je suis d\'accord, il faut continuer à suivre les performances de cette catégorie.', '2022-12-08', 4, 'i.carpentier'),
(23, 'Bonjour, je me suis inscrit au concours n°5, je suis prêt pour la compétition !', '2022-01-01', 5, 'c.leroy'),
(24, 'Bienvenue ! Nous sommes impatients de voir ce que tu as à nous montrer.', '2022-01-02', 5, 'a.david'),
(25, 'Merci beaucoup ! Je vais tout donner.', '2022-01-03', 5, 'c.leroy'),
(26, 'Bonjour, je viens de regarder les performances des candidats dans la catégorie U20 difficulté et je suis impressionné par leur niveau.', '2022-05-06', 6, 'c.leroy'),
(27, 'Je suis d\'accord avec toi c.leroy, il y a vraiment de très bons grimpeurs.', '2022-05-06', 6, 'a.david'),
(28, 'Il faut vraiment être vigilant pour faire les bons choix.', '2022-05-07', 6, 'b.garcia'),
(29, 'Je suis d\'accord, il y a vraiment beaucoup de talents cette année.', '2022-05-07', 6, 'e.petit'),
(30, 'La progression des candidats est intéressante à suivre.', '2022-08-01', 7, 'c.leroy'),
(31, 'Je suis d\'accord, ils ont tous un bon niveau.', '2022-08-02', 7, 'a.david'),
(32, 'Il y a deux ou trois candidats qui sortent du lot.', '2022-08-03', 7, 'b.garcia'),
(33, 'Oui, il faudra les surveiller de près.', '2022-08-04', 7, 'e.petit'),
(34, 'Il y a des candidats qui sont très techniques.', '2022-08-05', 7, 'd.roux'),
(35, 'Il y a des candidats qui sont très rapides.', '2022-08-06', 7, 'g.vergne'),
(36, 'Il y a des candidats qui sont très forts en bloc.', '2022-08-07', 7, 'h.bertrand'),
(37, 'Il faudra prendre en compte tous ces aspects pour évaluer les candidats.', '2022-08-08', 7, 'i.carpentier');

-- --------------------------------------------------------

--
-- Structure de la table `t_note_note`
--

CREATE TABLE `t_note_note` (
  `cpt_pseudo` varchar(50) NOT NULL,
  `part_mail` varchar(300) NOT NULL,
  `note_note` decimal(10,2) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Structure de la table `t_participant_part`
--

CREATE TABLE `t_participant_part` (
  `part_mail` varchar(300) NOT NULL,
  `part_codeInscription` char(20) NOT NULL,
  `part_codeIdentifiant` char(8) NOT NULL,
  `part_nom` varchar(80) NOT NULL,
  `part_prenom` varchar(80) NOT NULL,
  `cat_idCategorie` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

--
-- Déchargement des données de la table `t_participant_part`
--

INSERT INTO `t_participant_part` (`part_mail`, `part_codeInscription`, `part_codeIdentifiant`, `part_nom`, `part_prenom`, `cat_idCategorie`) VALUES
('b.durand@example.com', 'fDY11fMj88XEg35LWG46', 'yy18DL38', 'Durand', 'Bruno', 9),
('b.le-gall@gmail.com', 'jFh04Sct63QfU37JBH16', 'wn75dB71', 'Le Gall', 'Bastien', 9),
('chloe.dufour@gmail.com', 'HpQ26SpE63ipY25xcx88', 'LP58mZ73', 'Dufour', 'Chloe', 10),
('e.dupont@example.com', 'tSW07cim12Uhq15icw77', 'lo37BQ23', 'Dupont', 'Eric', 21),
('e.le-cunff@gmail.com', 'Ipv71xXf19Izh39boN25', 'lV97zx71', 'Le Cunff', 'Erwan', 1),
('emilie.leblanc@gmail.com', 'JIJ84sbr19rVY36qdf74', 'LC23cg16', 'Leblanc', 'Emilie', 10),
('emilie.lefebvre@gmail.com', 'Bka88VHj08CWa85fUB52', 'LN17EC89', 'Lefebvre', 'Emilie', 26),
('f.le-flem@gmail.com', 'Fht50iSl32ofX61HpY11', 'Qg38bV44', 'Le Flem', 'Fred', 11),
('g.leclerc@example.com', 'XsK79rwC66HJH09qTV56', 'vk65qc61', 'Leclerc', 'Gabriel', 9),
('j.francois@example.com', 'LFy88Imv62hZf17rIn16', 'hu21Pf34', 'Francois', 'Julien', 29),
('julien.petit@gmail.com', 'Oep10LbW43MBp15ZMw13', 'CY25Iu18', 'Petit', 'Julien', 19),
('lea.barnier@gmail.com', 'TIF44EKB18Tie66XVw28', 'Fq32fo28', 'Barnier', 'Léa', 22),
('lucas.durand@gmail.com', 'lle32tgp11Rse87Dtq83', 'Me74sd22', 'Durand', 'Lucas', 27),
('lucie.martin@gmail.com', 'nbv18GUp39Sxb32LPX24', 'JY24gE23', 'Martin', 'Lucie', 4),
('marie.robert@gmail.com', 'GNg71oTs23Pfh77Vcx04', 'jW50YQ14', 'Robert', 'Marie', 26),
('maxime.duval@gmail.com', 'YPa68MZD71Rss55nod09', 'wv73WT68', 'Duval', 'Maxime', 33),
('paul.dupont@gmail.com', 'VIp36KKc83PrB49bPt33', 'cm44Ut45', 'Dupont', 'Paul', 27),
('paul.lemoine@gmail.com', 'oSU45qVY71cMC77cCD53', 'MI85kZ42', 'Lemoine', 'Paul', 11),
('raphael.bernard@gmail.com', 'QXr26enW34Drj04yZD05', 'Lj65iX08', 'Bernard', 'Raphael', 1),
('s.martin@example.com', 'nVs01REK67thv34QOr27', 'Gb18ac31', 'Martin', 'Sophie', 2);

-- --------------------------------------------------------

--
-- Structure de la table `t_possede_poss`
--

CREATE TABLE `t_possede_poss` (
  `conc_idConcours` int(11) NOT NULL,
  `cat_idCategorie` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

--
-- Déchargement des données de la table `t_possede_poss`
--

INSERT INTO `t_possede_poss` (`conc_idConcours`, `cat_idCategorie`) VALUES
(1, 1),
(1, 2),
(1, 3),
(1, 4),
(1, 5),
(1, 6),
(1, 7),
(1, 8),
(1, 9),
(1, 10),
(1, 11),
(1, 12),
(1, 13),
(1, 14),
(1, 15),
(1, 16),
(1, 17),
(1, 18),
(1, 19),
(1, 20),
(1, 21),
(1, 22),
(1, 23),
(1, 24),
(1, 25),
(1, 26),
(1, 27),
(1, 28),
(1, 29),
(1, 30),
(1, 31),
(1, 32),
(1, 33),
(1, 34),
(1, 35),
(1, 36),
(2, 1),
(2, 2),
(2, 3),
(2, 4),
(2, 5),
(2, 6),
(2, 7),
(2, 8),
(2, 9),
(2, 10),
(2, 11),
(2, 12),
(2, 13),
(2, 14),
(2, 15),
(2, 16),
(2, 17),
(2, 18),
(2, 19),
(2, 20),
(2, 21),
(2, 22),
(2, 23),
(2, 24),
(2, 25),
(2, 26),
(2, 27),
(2, 28),
(2, 29),
(2, 30),
(2, 31),
(2, 32),
(2, 33),
(2, 34),
(2, 35),
(2, 36),
(3, 1),
(3, 2),
(3, 3),
(3, 4),
(3, 5),
(3, 6),
(3, 7),
(3, 8),
(3, 9),
(3, 10),
(3, 11),
(3, 12),
(3, 13),
(3, 14),
(3, 15),
(3, 16),
(3, 17),
(3, 18),
(3, 19),
(3, 20),
(3, 21),
(3, 22),
(3, 23),
(3, 24),
(3, 25),
(3, 26),
(3, 27),
(3, 28),
(3, 29),
(3, 30),
(3, 31),
(3, 32),
(3, 33),
(3, 34),
(3, 35),
(3, 36),
(4, 5),
(4, 6),
(4, 11),
(4, 12),
(4, 17),
(4, 18),
(4, 23),
(4, 24),
(4, 29),
(4, 30),
(4, 35),
(4, 36),
(5, 5),
(5, 6),
(5, 11),
(5, 12),
(5, 17),
(5, 18),
(5, 23),
(5, 24),
(5, 29),
(5, 30),
(5, 35),
(5, 36),
(6, 3),
(6, 4),
(6, 9),
(6, 10),
(6, 15),
(6, 16),
(6, 21),
(6, 22),
(6, 27),
(6, 28),
(6, 33),
(6, 34),
(7, 19),
(7, 20),
(7, 21),
(7, 22),
(7, 23),
(7, 24),
(7, 25),
(7, 26),
(7, 27),
(7, 28),
(7, 29),
(7, 30),
(7, 31),
(7, 32),
(7, 33),
(7, 34),
(7, 35),
(7, 36);

-- --------------------------------------------------------

--
-- Structure de la table `t_siege_siege`
--

CREATE TABLE `t_siege_siege` (
  `conc_idConcours` int(11) NOT NULL,
  `cpt_pseudo` varchar(50) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

--
-- Déchargement des données de la table `t_siege_siege`
--

INSERT INTO `t_siege_siege` (`conc_idConcours`, `cpt_pseudo`) VALUES
(1, 'a.david'),
(1, 'b.garcia'),
(1, 'c.leroy'),
(2, 'c.leroy'),
(2, 'd.roux'),
(2, 'e.petit'),
(3, 'a.david'),
(3, 'b.garcia'),
(3, 'd.roux'),
(4, 'a.david'),
(4, 'b.garcia'),
(4, 'c.leroy'),
(4, 'e.petit'),
(4, 'g.vergne'),
(5, 'd.roux'),
(5, 'g.vergne'),
(5, 'h.bertrand'),
(5, 'i.carpentier'),
(6, 'a.david'),
(6, 'b.garcia'),
(6, 'c.leroy'),
(6, 'd.roux'),
(6, 'e.petit'),
(7, 'c.leroy'),
(7, 'g.vergne'),
(7, 'h.bertrand'),
(7, 'i.carpentier');

--
-- Index pour les tables déchargées
--

--
-- Index pour la table `t_actualite_act`
--
ALTER TABLE `t_actualite_act`
  ADD PRIMARY KEY (`act_idActualite`),
  ADD KEY `fk_actualite_compte_org1_idx` (`cpt_pseudo`);

--
-- Index pour la table `t_categorie_cat`
--
ALTER TABLE `t_categorie_cat`
  ADD PRIMARY KEY (`cat_idCategorie`);

--
-- Index pour la table `t_compte_cpt`
--
ALTER TABLE `t_compte_cpt`
  ADD PRIMARY KEY (`cpt_pseudo`);

--
-- Index pour la table `t_compte_jury`
--
ALTER TABLE `t_compte_jury`
  ADD PRIMARY KEY (`cpt_pseudo`);

--
-- Index pour la table `t_compte_org`
--
ALTER TABLE `t_compte_org`
  ADD PRIMARY KEY (`cpt_pseudo`);

--
-- Index pour la table `t_concours_conc`
--
ALTER TABLE `t_concours_conc`
  ADD PRIMARY KEY (`conc_idConcours`),
  ADD KEY `fk_concours_compte_org1_idx` (`cpt_pseudo`);

--
-- Index pour la table `t_document_doc`
--
ALTER TABLE `t_document_doc`
  ADD PRIMARY KEY (`doc_idDocument`),
  ADD KEY `fk_document_participant1_idx` (`part_mail`);

--
-- Index pour la table `t_fil_fil`
--
ALTER TABLE `t_fil_fil`
  ADD PRIMARY KEY (`fil_idFil`),
  ADD KEY `fk_fil_concours1_idx` (`conc_idConcours`);

--
-- Index pour la table `t_message_msg`
--
ALTER TABLE `t_message_msg`
  ADD PRIMARY KEY (`msg_idMessage`),
  ADD KEY `fk_message_fil1_idx` (`fil_idFil`),
  ADD KEY `fk_message_compte_jury1_idx` (`cpt_pseudo`);

--
-- Index pour la table `t_note_note`
--
ALTER TABLE `t_note_note`
  ADD PRIMARY KEY (`cpt_pseudo`,`part_mail`),
  ADD KEY `fk_compte_jury_has_participant_participant1_idx` (`part_mail`),
  ADD KEY `fk_compte_jury_has_participant_compte_jury1_idx` (`cpt_pseudo`);

--
-- Index pour la table `t_participant_part`
--
ALTER TABLE `t_participant_part`
  ADD PRIMARY KEY (`part_mail`),
  ADD KEY `fk_participant_categorie1_idx` (`cat_idCategorie`);

--
-- Index pour la table `t_possede_poss`
--
ALTER TABLE `t_possede_poss`
  ADD PRIMARY KEY (`conc_idConcours`,`cat_idCategorie`),
  ADD KEY `fk_concours_has_categorie_categorie1_idx` (`cat_idCategorie`),
  ADD KEY `fk_concours_has_categorie_concours1_idx` (`conc_idConcours`);

--
-- Index pour la table `t_siege_siege`
--
ALTER TABLE `t_siege_siege`
  ADD PRIMARY KEY (`conc_idConcours`,`cpt_pseudo`),
  ADD KEY `fk_concours_has_compte_jury_compte_jury1_idx` (`cpt_pseudo`),
  ADD KEY `fk_concours_has_compte_jury_concours1_idx` (`conc_idConcours`);

--
-- AUTO_INCREMENT pour les tables déchargées
--

--
-- AUTO_INCREMENT pour la table `t_actualite_act`
--
ALTER TABLE `t_actualite_act`
  MODIFY `act_idActualite` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=8;

--
-- AUTO_INCREMENT pour la table `t_categorie_cat`
--
ALTER TABLE `t_categorie_cat`
  MODIFY `cat_idCategorie` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=37;

--
-- AUTO_INCREMENT pour la table `t_concours_conc`
--
ALTER TABLE `t_concours_conc`
  MODIFY `conc_idConcours` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=9;

--
-- AUTO_INCREMENT pour la table `t_document_doc`
--
ALTER TABLE `t_document_doc`
  MODIFY `doc_idDocument` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=13;

--
-- AUTO_INCREMENT pour la table `t_fil_fil`
--
ALTER TABLE `t_fil_fil`
  MODIFY `fil_idFil` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=8;

--
-- AUTO_INCREMENT pour la table `t_message_msg`
--
ALTER TABLE `t_message_msg`
  MODIFY `msg_idMessage` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=38;

--
-- Contraintes pour les tables déchargées
--

--
-- Contraintes pour la table `t_actualite_act`
--
ALTER TABLE `t_actualite_act`
  ADD CONSTRAINT `fk_actualite_compte_org1` FOREIGN KEY (`cpt_pseudo`) REFERENCES `t_compte_org` (`cpt_pseudo`) ON DELETE NO ACTION ON UPDATE NO ACTION;

--
-- Contraintes pour la table `t_compte_jury`
--
ALTER TABLE `t_compte_jury`
  ADD CONSTRAINT `fk_compte_jury_compte1` FOREIGN KEY (`cpt_pseudo`) REFERENCES `t_compte_cpt` (`cpt_pseudo`) ON DELETE NO ACTION ON UPDATE NO ACTION;

--
-- Contraintes pour la table `t_compte_org`
--
ALTER TABLE `t_compte_org`
  ADD CONSTRAINT `fk_compte_org_compte` FOREIGN KEY (`cpt_pseudo`) REFERENCES `t_compte_cpt` (`cpt_pseudo`) ON DELETE NO ACTION ON UPDATE NO ACTION;

--
-- Contraintes pour la table `t_concours_conc`
--
ALTER TABLE `t_concours_conc`
  ADD CONSTRAINT `fk_concours_compte_org1` FOREIGN KEY (`cpt_pseudo`) REFERENCES `t_compte_org` (`cpt_pseudo`) ON DELETE NO ACTION ON UPDATE NO ACTION;

--
-- Contraintes pour la table `t_document_doc`
--
ALTER TABLE `t_document_doc`
  ADD CONSTRAINT `fk_document_participant1` FOREIGN KEY (`part_mail`) REFERENCES `t_participant_part` (`part_mail`) ON DELETE NO ACTION ON UPDATE NO ACTION;

--
-- Contraintes pour la table `t_fil_fil`
--
ALTER TABLE `t_fil_fil`
  ADD CONSTRAINT `fk_fil_concours1` FOREIGN KEY (`conc_idConcours`) REFERENCES `t_concours_conc` (`conc_idConcours`) ON DELETE NO ACTION ON UPDATE NO ACTION;

--
-- Contraintes pour la table `t_message_msg`
--
ALTER TABLE `t_message_msg`
  ADD CONSTRAINT `fk_message_compte_jury1` FOREIGN KEY (`cpt_pseudo`) REFERENCES `t_compte_jury` (`cpt_pseudo`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  ADD CONSTRAINT `fk_message_fil1` FOREIGN KEY (`fil_idFil`) REFERENCES `t_fil_fil` (`fil_idFil`) ON DELETE NO ACTION ON UPDATE NO ACTION;

--
-- Contraintes pour la table `t_note_note`
--
ALTER TABLE `t_note_note`
  ADD CONSTRAINT `fk_compte_jury_has_participant_compte_jury1` FOREIGN KEY (`cpt_pseudo`) REFERENCES `t_compte_jury` (`cpt_pseudo`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  ADD CONSTRAINT `fk_compte_jury_has_participant_participant1` FOREIGN KEY (`part_mail`) REFERENCES `t_participant_part` (`part_mail`) ON DELETE NO ACTION ON UPDATE NO ACTION;

--
-- Contraintes pour la table `t_participant_part`
--
ALTER TABLE `t_participant_part`
  ADD CONSTRAINT `fk_participant_categorie1` FOREIGN KEY (`cat_idCategorie`) REFERENCES `t_categorie_cat` (`cat_idCategorie`) ON DELETE NO ACTION ON UPDATE NO ACTION;

--
-- Contraintes pour la table `t_possede_poss`
--
ALTER TABLE `t_possede_poss`
  ADD CONSTRAINT `fk_concours_has_categorie_categorie1` FOREIGN KEY (`cat_idCategorie`) REFERENCES `t_categorie_cat` (`cat_idCategorie`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  ADD CONSTRAINT `fk_concours_has_categorie_concours1` FOREIGN KEY (`conc_idConcours`) REFERENCES `t_concours_conc` (`conc_idConcours`) ON DELETE NO ACTION ON UPDATE NO ACTION;

--
-- Contraintes pour la table `t_siege_siege`
--
ALTER TABLE `t_siege_siege`
  ADD CONSTRAINT `fk_concours_has_compte_jury_compte_jury1` FOREIGN KEY (`cpt_pseudo`) REFERENCES `t_compte_jury` (`cpt_pseudo`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  ADD CONSTRAINT `fk_concours_has_compte_jury_concours1` FOREIGN KEY (`conc_idConcours`) REFERENCES `t_concours_conc` (`conc_idConcours`) ON DELETE NO ACTION ON UPDATE NO ACTION;
COMMIT;
